﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using KMotion_dotNet;
using System.Windows.Forms;
using System.Reflection;
using System.IO;
using KFlopWebNC.DOM_Helpers;

namespace KFlopWebNC.Model
{
    public partial class DeviceInteropHandler
    {
        public void CreateX(int channel, double movespeed, double jogspeed)
        {
            string axisname = "X";
            SetAxis(axisname, channel, movespeed, jogspeed);
        }
        public void CreateY(int channel, double movespeed, double jogspeed)
        {
            string axisname = "Y";
            SetAxis(axisname, channel, movespeed, jogspeed);
        }
        public void CreateZ(int channel, double movespeed, double jogspeed)
        {
            string axisname = "Z";
            SetAxis(axisname, channel, movespeed, jogspeed);
        }
        public void CreateA(int channel, double movespeed, double jogspeed)
        {
            string axisname = "A";
            SetAxis(axisname, channel, movespeed, jogspeed);
        }
        public void CreateB(int channel, double movespeed, double jogspeed)
        {
            string axisname = "B";
            SetAxis(axisname, channel, movespeed, jogspeed);
        }
        public void CreateC(int channel, double movespeed, double jogspeed)
        {
            string axisname = "C";
            SetAxis(axisname, channel, movespeed, jogspeed);
        }

        public void SetAxis(string axisname, int channel, double movespeed, double jogspeed)
        { 
            if (_AxisContainer.ContainsKey(axisname))
            {
                _AxisContainer[axisname].Axis.ID = channel;
                _AxisContainer[axisname].JogVelocity = jogspeed;
                _AxisContainer[axisname].Axis.Velocity = movespeed;
            }
            else
            {
                _AxisContainer.Add(axisname, new AxisNode(new KM_Axis(_Controller, channel, "X")));
                _AxisContainer[axisname].JogVelocity = jogspeed;
                _AxisContainer[axisname].Axis.Velocity = movespeed;
            }
        }

        public void EnableX()
        {
            if (IsConnected)
            {
                if (_AxisContainer.ContainsKey("X"))
                {
                    var axis = _AxisContainer["X"].Axis;
                    if (axis.CheckEnabled())
                    {
                        axis.Disable();
                    }
                    else
                    {
                        axis.Enable();
                    }
                }
            }
        }
        public void EnableY()
        {
            if (IsConnected)
            {
                if (_AxisContainer.ContainsKey("Y"))
                {
                    var axis = _AxisContainer["Y"].Axis;
                    if (axis.CheckEnabled())
                    {
                        axis.Disable();
                    }
                    else
                    {
                        axis.Enable();
                    }
                }
            }
        }
        public void EnableZ()
        {
            if (IsConnected)
            {
                if (_AxisContainer.ContainsKey("Z"))
                {
                    var axis = _AxisContainer["Z"].Axis;
                    if (axis.CheckEnabled())
                    {
                        axis.Disable();
                    }
                    else
                    {
                        axis.Enable();
                    }
                }
            }
        }
        public void EnableA()
        {
            if (IsConnected)
            {
                if (_AxisContainer.ContainsKey("A"))
                {
                    var axis = _AxisContainer["A"].Axis;
                    if (axis.CheckEnabled())
                    {
                        axis.Disable();
                    }
                    else
                    {
                        axis.Enable();
                    }
                }
            }
        }
        public void EnableB()
        {
            if (IsConnected)
            {
                if (_AxisContainer.ContainsKey("B"))
                {
                    var axis = _AxisContainer["B"].Axis;
                    if (axis.CheckEnabled())
                    {
                        axis.Disable();
                    }
                    else
                    {
                        axis.Enable();
                    }
                }
            }
        }
        public void EnableC()
        {
            if (IsConnected)
            {
                if (_AxisContainer.ContainsKey("C"))
                {
                    var axis = _AxisContainer["C"].Axis;
                    if (axis.CheckEnabled())
                    {
                        axis.Disable();
                    }
                    else
                    {
                        axis.Enable();
                    }
                }
            }
        }

        public bool IsEnabledX()
        { 
            if (IsConnected)
            {
                if (_AxisContainer.ContainsKey("X"))
                {
                    var axis = _AxisContainer["X"].Axis;
                    return axis.CheckEnabled();
                }
                return false;
            }
            else
            {
                return false;
            }
        }
        public bool IsEnabledY()
        {
            if (IsConnected)
            {
                if (_AxisContainer.ContainsKey("Y"))
                {
                    var axis = _AxisContainer["Y"].Axis;
                    return axis.CheckEnabled();
                }
                return false;
            }
            else
            {
                return false;
            }
        }
        public bool IsEnabledZ()
        {
            if (IsConnected)
            {
                if (_AxisContainer.ContainsKey("Z"))
                {
                    var axis = _AxisContainer["Z"].Axis;
                    return axis.CheckEnabled();
                }
                return false;
            }
            else
            {
                return false;
            }
        }
        public bool IsEnabledA()
        {
            if (IsConnected)
            {
                if (_AxisContainer.ContainsKey("A"))
                {
                    var axis = _AxisContainer["A"].Axis;
                    return axis.CheckEnabled();
                }
                return false;
            }
            else
            {
                return false;
            }
        }
        public bool IsEnabledB()
        {
            if (IsConnected)
            {
                if (_AxisContainer.ContainsKey("B"))
                {
                    var axis = _AxisContainer["B"].Axis;
                    return axis.CheckEnabled();
                }
                return false;
            }
            else
            {
                return false;
            }
        }
        public bool IsEnabledC()
        {
            if (IsConnected)
            {
                if (_AxisContainer.ContainsKey("C"))
                {
                    var axis = _AxisContainer["C"].Axis;
                    return axis.CheckEnabled();
                }
                return false;
            }
            else
            {
                return false;
            }
        }

        public void StopX()
        {
            if (IsConnected)
            {
                if (_AxisContainer.ContainsKey("X"))
                {
                    _AxisContainer["X"].Axis.Stop();
                }
            }
        }
        public void StopY()
        {
            if (IsConnected)
            {
                if (_AxisContainer.ContainsKey("Y"))
                {
                    _AxisContainer["Y"].Axis.Stop();
                }
            }
        }
        public void StopZ()
        {
            if (IsConnected)
            {
                if (_AxisContainer.ContainsKey("Z"))
                {
                    _AxisContainer["Z"].Axis.Stop();
                }
            }
        }
        public void StopA()
        {
            if (IsConnected)
            {
                if (_AxisContainer.ContainsKey("A"))
                {
                    _AxisContainer["A"].Axis.Stop();
                }
            }
        }
        public void StopB()
        {
            if (IsConnected)
            {
                if (_AxisContainer.ContainsKey("B"))
                {
                    _AxisContainer["B"].Axis.Stop();
                }
            }
        }
        public void StopC()
        {
            if (IsConnected)
            {
                if (_AxisContainer.ContainsKey("C"))
                {
                    _AxisContainer["C"].Axis.Stop();
                }
            }
        }

        public void ZeroX()
        {
            if (IsConnected)
            {
                if (_AxisContainer.ContainsKey("X"))
                {
                    _AxisContainer["X"].Axis.ZeroAxis();
                }
            }
        }
        public void ZeroY()
        {
            if (IsConnected)
            {
                if (_AxisContainer.ContainsKey("Y"))
                {
                    _AxisContainer["Y"].Axis.ZeroAxis();
                }
            }
        }
        public void ZeroZ()
        {
            if (IsConnected)
            {
                if (_AxisContainer.ContainsKey("Z"))
                {
                    _AxisContainer["Z"].Axis.ZeroAxis();
                }
            }
        }
        public void ZeroA()
        {
            if (IsConnected)
            {
                if (_AxisContainer.ContainsKey("A"))
                {
                    _AxisContainer["A"].Axis.ZeroAxis();
                }
            }
        }
        public void ZeroB()
        {
            if (IsConnected)
            {
                if (_AxisContainer.ContainsKey("B"))
                {
                    _AxisContainer["B"].Axis.ZeroAxis();
                }
            }
        }
        public void ZeroC()
        {
            if (IsConnected)
            {
                if (_AxisContainer.ContainsKey("C"))
                {
                    _AxisContainer["C"].Axis.ZeroAxis();
                }
            }
        }

        public void SetJogPercentX(double percent)
        {
            if (IsConnected)
            {
                if (_AxisContainer.ContainsKey("X"))
                {
                    _AxisContainer["X"].JogPercent = percent / 100;
                }
            }
        }
        public void SetJogPercentY(double percent)
        {
            if (IsConnected)
            {
                if (_AxisContainer.ContainsKey("Y"))
                {
                    _AxisContainer["Y"].JogPercent = percent / 100;
                }
            }
        }
        public void SetJogPercentZ(double percent)
        {
            if (IsConnected)
            {
                if (_AxisContainer.ContainsKey("Z"))
                {
                    _AxisContainer["Z"].JogPercent = percent / 100;
                }
            }
        }
        public void SetJogPercentA(double percent)
        {
            if (IsConnected)
            {
                if (_AxisContainer.ContainsKey("A"))
                {
                    _AxisContainer["A"].JogPercent = percent / 100;
                }
            }
        }
        public void SetJogPercentB(double percent)
        {
            if (IsConnected)
            {
                if (_AxisContainer.ContainsKey("B"))
                {
                    _AxisContainer["B"].JogPercent = percent / 100;
                }
            }
        }
        public void SetJogPercentC(double percent)
        {
            if (IsConnected)
            {
                if (_AxisContainer.ContainsKey("C"))
                {
                    _AxisContainer["C"].JogPercent = percent / 100;
                }
            }
        }

        public void JogXPositive()
        {
            if (IsConnected)
            {
                if (_AxisContainer.ContainsKey("X"))
                {
                    _AxisContainer["X"].Axis.Jog(_AxisContainer["X"].JogVelocity * _AxisContainer["X"].JogPercent);
                }
            }
        }
        public void JogYPositive()
        {
            if (IsConnected)
            {
                if (_AxisContainer.ContainsKey("Y"))
                {
                    _AxisContainer["Y"].Axis.Jog(_AxisContainer["Y"].JogVelocity * _AxisContainer["Y"].JogPercent);
                }
            }
        }
        public void JogZPositive()
        {
            if (IsConnected)
            {
                if (_AxisContainer.ContainsKey("Z"))
                {
                    _AxisContainer["Z"].Axis.Jog(_AxisContainer["Z"].JogVelocity * _AxisContainer["Z"].JogPercent);
                }
            }
        }
        public void JogAPositive()
        {
            if (IsConnected)
            {
                if (_AxisContainer.ContainsKey("A"))
                {
                    _AxisContainer["A"].Axis.Jog(_AxisContainer["A"].JogVelocity * _AxisContainer["A"].JogPercent);
                }
            }
        }
        public void JogBPositive()
        {
            if (IsConnected)
            {
                if (_AxisContainer.ContainsKey("B"))
                {
                    _AxisContainer["B"].Axis.Jog(_AxisContainer["B"].JogVelocity * _AxisContainer["B"].JogPercent);
                }
            }
        }
        public void JogCPositive()
        {
            if (IsConnected)
            {
                if (_AxisContainer.ContainsKey("C"))
                {
                    _AxisContainer["C"].Axis.Jog(_AxisContainer["C"].JogVelocity * _AxisContainer["C"].JogPercent);
                }
            }
        }

        public void JogXNegative()
        {
            if (IsConnected)
            {
                if (_AxisContainer.ContainsKey("X"))
                {
                    _AxisContainer["X"].Axis.Jog(-(_AxisContainer["X"].JogVelocity * _AxisContainer["X"].JogPercent));
                }
            }
        }
        public void JogYNegative()
        {
            if (IsConnected)
            {
                if (_AxisContainer.ContainsKey("Y"))
                {
                    _AxisContainer["Y"].Axis.Jog(-(_AxisContainer["Y"].JogVelocity * _AxisContainer["Y"].JogPercent));
                }
            }
        }
        public void JogZNegative()
        {
            if (IsConnected)
            {
                if (_AxisContainer.ContainsKey("Z"))
                {
                    _AxisContainer["Z"].Axis.Jog(-(_AxisContainer["Z"].JogVelocity * _AxisContainer["Z"].JogPercent));
                }
            }
        }
        public void JogANegative()
        {
            if (IsConnected)
            {
                if (_AxisContainer.ContainsKey("A"))
                {
                    _AxisContainer["A"].Axis.Jog(-(_AxisContainer["A"].JogVelocity * _AxisContainer["A"].JogPercent));
                }
            }
        }
        public void JogBNegative()
        {
            if (IsConnected)
            {
                if (_AxisContainer.ContainsKey("B"))
                {
                    _AxisContainer["B"].Axis.Jog(-(_AxisContainer["B"].JogVelocity * _AxisContainer["B"].JogPercent));
                }
            }
        }
        public void JogCNegative()
        {
            if (IsConnected)
            {
                if (_AxisContainer.ContainsKey("C"))
                {
                    _AxisContainer["C"].Axis.Jog(-(_AxisContainer["C"].JogVelocity * _AxisContainer["C"].JogPercent));
                }
            }
        }

        public void MoveX(object position)
        {
            if (IsConnected)
            {
                if (_AxisContainer.ContainsKey("X"))
                {
                    double pos = 0.0;
                    if (double.TryParse(position.ToString(), out pos))
                    {
                        _AxisContainer["X"].Axis.MoveTo(pos);
                    }
                }
            }
        }
        public void MoveY(double position)
        {
            if (IsConnected)
            {
                if (_AxisContainer.ContainsKey("Y"))
                {
                    _AxisContainer["Y"].Axis.MoveTo(position);
                }
            }
        }
        public void MoveZ(double position)
        {
            if (IsConnected)
            {
                if (_AxisContainer.ContainsKey("Z"))
                {
                    _AxisContainer["Z"].Axis.MoveTo(position);
                }
            }
        }
        public void MoveA(double position)
        {
            if (IsConnected)
            {
                if (_AxisContainer.ContainsKey("A"))
                {
                    _AxisContainer["A"].Axis.MoveTo(position);
                }
            }
        }
        public void MoveB(double position)
        {
            if (IsConnected)
            {
                if (_AxisContainer.ContainsKey("B"))
                {
                    _AxisContainer["B"].Axis.MoveTo(position);
                }
            }
        }
        public void MoveC(double position)
        {
            if (IsConnected)
            {
                if (_AxisContainer.ContainsKey("C"))
                {
                    _AxisContainer["C"].Axis.MoveTo(position);
                }
            }
        }

        public void UpdateJogRates()
        {
            var jog = "100%";

            UpdateDocument(new Action(delegate()
            {
                if (_AxisContainer.ContainsKey("X"))
                {
                    jog = String.Format("{0}%", Math.Round(100 * (_AxisContainer["X"].JogPercent), 0));

                    _GuiHost.SetElementText(Elements.ValueXJogPercent, jog);

                }
                if (_AxisContainer.ContainsKey("Y"))
                {
                    jog = String.Format("{0}%", Math.Round(100 * (_AxisContainer["Y"].JogPercent), 0));

                    _GuiHost.SetElementText(Elements.ValueYJogPercent, jog);

                }
                if (_AxisContainer.ContainsKey("Z"))
                {
                    jog = String.Format("{0}%", Math.Round(100 * (_AxisContainer["Z"].JogPercent), 0));

                    _GuiHost.SetElementText(Elements.ValueZJogPercent, jog);

                }
                if (_AxisContainer.ContainsKey("A"))
                {
                    jog = String.Format("{0}%", Math.Round(100 * (_AxisContainer["A"].JogPercent), 0));

                    _GuiHost.SetElementText(Elements.ValueAJogPercent, jog);

                }
                if (_AxisContainer.ContainsKey("B"))
                {
                    jog = String.Format("{0}%", Math.Round(100 * (_AxisContainer["B"].JogPercent), 0));

                    _GuiHost.SetElementText(Elements.ValueBJogPercent, jog);

                }
                if (_AxisContainer.ContainsKey("C"))
                {
                    jog = String.Format("{0}%", Math.Round(100 * (_AxisContainer["C"].JogPercent), 0));

                    _GuiHost.SetElementText(Elements.ValueCJogPercent, jog);

                }
            }));
        }

   
    }
}
